package ru.yandex.solomon.project.manager.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.project.manager.AccessServiceGrpc;
import ru.yandex.monitoring.api.v3.project.manager.AuthorizeRequest;
import ru.yandex.monitoring.api.v3.project.manager.AuthorizeResponse;
import ru.yandex.monitoring.api.v3.project.manager.AvailableResourcesRequest;
import ru.yandex.monitoring.api.v3.project.manager.AvailableResourcesResponse;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;
import ru.yandex.solomon.project.manager.api.v3.intranet.AccessService;

/**
 * @author Alexey Trushkin
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcAccessService extends AccessServiceGrpc.AccessServiceImplBase implements GrpcService {

    private final AccessService accessService;

    @Autowired
    public GrpcAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    @Override
    public void authorize(AuthorizeRequest request, StreamObserver<AuthorizeResponse> responseObserver) {
        GrpcMethodHandler.handle(accessService::authorize, request, responseObserver);
    }

    @Override
    public void availableResources(AvailableResourcesRequest request, StreamObserver<AvailableResourcesResponse> responseObserver) {
        GrpcMethodHandler.handle(accessService::availableResources, request, responseObserver);
    }
}
