package ru.yandex.solomon.project.manager.api.v3.intranet.impl;

import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.monitoring.api.v3.project.manager.AuthorizeRequest;
import ru.yandex.monitoring.api.v3.project.manager.AuthorizeResponse;
import ru.yandex.monitoring.api.v3.project.manager.AvailableResourcesRequest;
import ru.yandex.monitoring.api.v3.project.manager.AvailableResourcesResponse;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.AuthorizationObject;
import ru.yandex.solomon.auth.Authorizer;
import ru.yandex.solomon.auth.dto.AccessDtoConverter;
import ru.yandex.solomon.auth.roles.Permission;
import ru.yandex.solomon.project.manager.api.v3.intranet.AccessService;
import ru.yandex.solomon.project.manager.api.v3.intranet.validators.AccessServiceValidator;

/**
 * @author Alexey Trushkin
 */
@Component
@ParametersAreNonnullByDefault
public class AccessServiceImpl implements AccessService {

    private final Authorizer authorizer;
    private final AccessServiceValidator validator;

    public AccessServiceImpl(Authorizer authorizer) {
        this.authorizer = authorizer;
        validator = new AccessServiceValidator();
    }

    @Override
    public CompletableFuture<AuthorizeResponse> authorize(AuthorizeRequest request, AuthSubject ignore) {
        validator.validate(request);
        var subject = AccessDtoConverter.fromProto(request.getSubject());
        var object = AccessDtoConverter.fromProto(request.getResourcePath());
        var permission = Permission.fromString(request.getPermission());
        return authorizer.authorize(subject, object, permission)
                .thenApply(AccessDtoConverter::toProto);
    }

    @Override
    public CompletableFuture<AvailableResourcesResponse> availableResources(
            AvailableResourcesRequest request,
            AuthSubject ignore)
    {
        validator.validate(request);
        var subject = AccessDtoConverter.fromProto(request.getSubject());
        var roles = AccessDtoConverter.fromProto(request.getRolesList());
        return authorizer.getAvailableAuthorizationObjects(subject, roles, EnumSet.allOf(AuthorizationObject.Type.class))
                .thenApply(AccessDtoConverter::toProto);
    }
}
