package ru.yandex.solomon.project.manager.api.v3.intranet.impl.listener;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.juggler.client.JugglerProjectChangesClient;
import ru.yandex.monitoring.api.v3.project.manager.DeleteProjectRequest;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.flags.FeatureFlag;
import ru.yandex.solomon.flags.FeatureFlagsHolder;
import ru.yandex.solomon.project.manager.api.util.ProtoJsonUtils;
import ru.yandex.solomon.project.manager.api.v3.intranet.ProjectChangeListener;
import ru.yandex.solomon.project.manager.api.v3.intranet.dto.ProjectDtoConverter;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class JugglerProjectChangeListener implements ProjectChangeListener {

    private static final Logger logger = LoggerFactory.getLogger(JugglerProjectChangeListener.class);
    private final JugglerProjectChangesClient client;
    private final FeatureFlagsHolder featureFlagsHolder;
    private final ProjectDtoConverter converter;

    public JugglerProjectChangeListener(JugglerProjectChangesClient client, FeatureFlagsHolder featureFlagsHolder) {
        this.client = client;
        this.featureFlagsHolder = featureFlagsHolder;
        converter = new ProjectDtoConverter();
    }

    @Override
    public CompletableFuture<Void> create(Project result) {
        if (!featureFlagsHolder.hasFlag(FeatureFlag.USE_PM_JUGGLER_INTEGRATION, FeatureFlag.USE_PM_JUGGLER_INTEGRATION.name())) {
            logger.info("Integration disabled");
            return CompletableFuture.completedFuture(null);
        }
        var body = ProtoJsonUtils.toJson(converter.fromEntity(result), false);
        return client.createProject(body);
    }

    @Override
    public CompletableFuture<Void> update(Project result) {
        if (!featureFlagsHolder.hasFlag(FeatureFlag.USE_PM_JUGGLER_INTEGRATION, FeatureFlag.USE_PM_JUGGLER_INTEGRATION.name())) {
            logger.info("Integration disabled");
            return CompletableFuture.completedFuture(null);
        }
        var body = ProtoJsonUtils.toJson(converter.fromEntity(result), false);
        return client.updateProject(body);
    }

    @Override
    public CompletableFuture<Void> delete(DeleteProjectRequest request) {
        if (!featureFlagsHolder.hasFlag(FeatureFlag.USE_PM_JUGGLER_INTEGRATION, FeatureFlag.USE_PM_JUGGLER_INTEGRATION.name())) {
            logger.info("Integration disabled");
            return CompletableFuture.completedFuture(null);
        }
        var body = ProtoJsonUtils.toJson(request, false);
        return client.deleteProject(body);
    }

    @Override
    public CompletableFuture<Void> preDeleteAction(DeleteProjectRequest request) {
        return CompletableFuture.completedFuture(null);
    }
}
