package ru.yandex.solomon.project.manager.api.v3.intranet.rest;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.Api;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.monitoring.api.v3.project.manager.AuthorizeRequest;
import ru.yandex.monitoring.api.v3.project.manager.AvailableResourcesRequest;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.http.RequireAuth;
import ru.yandex.solomon.project.manager.api.util.ProtoJsonUtils;
import ru.yandex.solomon.project.manager.api.v3.intranet.AccessService;

/**
 * @author Alexey Trushkin
 */
@Api(tags = "access")
@RestController
@RequestMapping(produces = MediaType.APPLICATION_JSON_VALUE)
@ParametersAreNonnullByDefault
public class AccessServiceController {

    private final AccessService service;

    public AccessServiceController(AccessService service) {
        this.service = service;
    }

    @PostMapping(path = "/api/v3/access/authorize")
    CompletableFuture<String> authorize(
            @RequireAuth AuthSubject subject,
            @RequestParam(value = "_pretty", defaultValue = "false") boolean pretty,
            @RequestBody byte[] body)
    {
        return CompletableFutures.safeCall(() -> {
            AuthorizeRequest.Builder builder = AuthorizeRequest.newBuilder();
            ProtoJsonUtils.fromJson(body, builder);
            AuthorizeRequest request = builder.build();

            return service.authorize(request, subject);
        })
                .thenApply(response -> ProtoJsonUtils.toJson(response, pretty));
    }

    @GetMapping(path = "/api/v3/access/availableResources")
    CompletableFuture<String> getAvailableResources(
            @RequireAuth AuthSubject subject,
            @RequestParam(value = "_pretty", defaultValue = "false") boolean pretty,
            @RequestBody byte[] body)
    {
        return CompletableFutures.safeCall(() -> {
            AvailableResourcesRequest.Builder builder = AvailableResourcesRequest.newBuilder();
            ProtoJsonUtils.fromJson(body, builder);
            AvailableResourcesRequest request = builder.build();

            return service.availableResources(request, subject);
        })
                .thenApply(response -> ProtoJsonUtils.toJson(response, pretty));
    }
}
