package ru.yandex.solomon.project.manager.api.v3.intranet.validators;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.dao.ProjectsDao;
import ru.yandex.solomon.core.exceptions.BadRequestException;
import ru.yandex.solomon.project.manager.api.v3.intranet.impl.ProjectServiceImpl;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class AbcToProjectMappingValidator {
    private final ProjectsDao projectsDao;

    public AbcToProjectMappingValidator(ProjectsDao projectsDao) {

        this.projectsDao = projectsDao;
    }

    public void validate(String abcSlug) {
        if (abcSlug.isBlank()) {
            throw new BadRequestException("abc slug cannot be blank");
        }
    }

    public CompletableFuture<Void> validate(String abcSlug, String projectId) {
        if (abcSlug.isBlank()) {
            return CompletableFuture.failedFuture(new BadRequestException("abc slug cannot be blank"));
        }
        if (projectId.isBlank()) {
            return CompletableFuture.failedFuture(new BadRequestException("project id cannot be blank"));
        }
        return projectsDao.findById(projectId)
                .thenApply(projectOptional -> {
                    if (projectOptional.isEmpty()) {
                        throw ProjectServiceImpl.projectNotFound(projectId);
                    }
                    if (!abcSlug.equals(projectOptional.get().getAbcService())) {
                        throw new BadRequestException(
                                String.format("invalid abc slug, project ='%s', requestAbc='%s'", projectOptional.get().getAbcService(), abcSlug)
                        );
                    }
                    return null;
                });
    }
}
