package ru.yandex.solomon.project.manager.api.v3.intranet.validators;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.api.v3.project.manager.AuthorizeRequest;
import ru.yandex.monitoring.api.v3.project.manager.AvailableResourcesRequest;
import ru.yandex.monitoring.api.v3.project.manager.Resource;
import ru.yandex.solomon.auth.roles.Permission;
import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class AccessServiceValidator {

    public void validate(AuthorizeRequest request) {
        if (request.getPermission().isBlank()) {
            throw new BadRequestException("permission cannot be blank");
        }
        if (request.getResourcePath().getPathList().isEmpty()) {
            throw new BadRequestException("resource path cannot be empty");
        }
        for (Resource resource : request.getResourcePath().getPathList()) {
            if (resource.getId().isBlank()) {
                throw new BadRequestException("resource id cannot be blank");
            }
            if (resource.getType().isBlank()) {
                throw new BadRequestException("resource type cannot be blank");
            }
        }
        if (Permission.fromString(request.getPermission()) == null) {
            throw new BadRequestException("unknown permission " + request.getPermission());
        }
    }

    public void validate(AvailableResourcesRequest request) {
        if (request.getRolesList().isEmpty()) {
            throw new BadRequestException("roles cannot be empty");
        }
    }
}
