package ru.yandex.solomon.project.manager.api.v3.intranet.validators;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.monitoring.api.v3.project.manager.CreateProjectRequest;
import ru.yandex.monitoring.api.v3.project.manager.DeleteProjectRequest;
import ru.yandex.monitoring.api.v3.project.manager.GetProjectRequest;
import ru.yandex.monitoring.api.v3.project.manager.UpdateProjectRequest;
import ru.yandex.solomon.core.exceptions.BadRequestException;
import ru.yandex.solomon.core.validators.IdValidator;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class ProjectValidator {

    public void validate(GetProjectRequest request) {
        if (request.getProjectId().isBlank()) {
            throw new BadRequestException("project ID cannot be blank");
        }
    }

    public void validate(CreateProjectRequest request) {
        if (request.getIdCase() != CreateProjectRequest.IdCase.PROJECT_ID) {
            throw new BadRequestException(request.getIdCase() + " not supported");
        }
        IdValidator.ensureProjectIdValid(request.getProjectId());
        if (StringUtils.isBlank(request.getName())) {
            throw new BadRequestException("name cannot be blank");
        }
        if (StringUtils.isBlank(request.getAbcService())) {
            throw new BadRequestException("abcService cannot be blank");
        }
    }

    public void validate(UpdateProjectRequest request) {
        if (request.getIdCase() != UpdateProjectRequest.IdCase.PROJECT_ID) {
            throw new BadRequestException(request.getIdCase() + " not supported");
        }
        IdValidator.ensureProjectIdValid(request.getProjectId());
        if (StringUtils.isBlank(request.getName())) {
            throw new BadRequestException("name cannot be blank");
        }
        if (StringUtils.isBlank(request.getAbcService())) {
            throw new BadRequestException("abcService cannot be blank");
        }
    }

    public void validate(DeleteProjectRequest request) {
        if (request.getProjectId().isBlank()) {
            throw new BadRequestException("project ID cannot be blank");
        }
    }
}
