package ru.yandex.solomon.project.manager.spring;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.auth.Authorizer;
import ru.yandex.solomon.core.db.dao.ProjectsDao;
import ru.yandex.solomon.project.manager.abc.db.AbcToProjectMappingDao;
import ru.yandex.solomon.project.manager.api.v3.intranet.AbcToProjectMappingService;
import ru.yandex.solomon.project.manager.api.v3.intranet.impl.AbcToProjectMappingServiceImpl;

/**
 * @author Alexey Trushkin
 */
@Configuration
@ParametersAreNonnullByDefault
public class AbcToProjectMappingContext {

    @Bean
    public AbcToProjectMappingService abcToProjectMappingService(
            Optional<AbcToProjectMappingDao> abcToProjectMappingDao,
            ProjectsDao projectsDao,
            Authorizer authorizer
    ) {
        if (abcToProjectMappingDao.isEmpty()) {
            return null;
        }
        return new AbcToProjectMappingServiceImpl(abcToProjectMappingDao.get(), projectsDao, authorizer);
    }
}
