package ru.yandex.solomon.project.manager.spring;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;

import ru.yandex.solomon.selfmon.mon.SelfMetricsController;
import ru.yandex.solomon.staffOnly.StaffOnlyController;
import ru.yandex.solomon.staffOnly.StaffOnlyRedirectController;

/**
 * @author Alexey Trushkin
 */
@Import({
        StaffOnlyController.class,
        StaffOnlyRedirectController.class,
        SelfMetricsController.class,
})
@Configuration
public class PrivateHttpServerConfig {

    @Bean
    public HandlerAdapter handlerAdapter() {
        return new RequestMappingHandlerAdapter();
    }

    @Bean
    public HandlerMapping handlerMapping() {
        return new RequestMappingHandlerMapping();
    }
}

