package ru.yandex.solomon.project.manager.spring;

import java.util.List;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.grpc.conf.GrpcConfigurationContext;
import ru.yandex.solomon.abc.validator.AbcServiceFieldValidator;
import ru.yandex.solomon.acl.db.AclDaoContext;
import ru.yandex.solomon.auth.AuthContext;
import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.core.conf.SolomonConfManager;
import ru.yandex.solomon.core.conf.flags.FeatureFlagsContext;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.core.conf.watch.SolomonConfListener;
import ru.yandex.solomon.core.conf.watch.SolomonConfWatcher;
import ru.yandex.solomon.core.db.dao.ProjectsDao;
import ru.yandex.solomon.core.db.dao.ServiceProvidersDao;
import ru.yandex.solomon.core.db.dao.memory.InMemoryClustersDao;
import ru.yandex.solomon.core.db.dao.memory.InMemoryServicesDao;
import ru.yandex.solomon.core.db.dao.memory.InMemoryShardDao;
import ru.yandex.solomon.ctx.ServiceAuthContext;
import ru.yandex.solomon.exception.handlers.HttpApiExceptionHandler;
import ru.yandex.solomon.http.filters.BrokenPipeMuteFilter;
import ru.yandex.solomon.http.filters.FixContentTypeHeader;
import ru.yandex.solomon.http.filters.HttpFirewallFilter;
import ru.yandex.solomon.http.filters.RequestLoggingFilter;
import ru.yandex.solomon.project.manager.spring.cloud.ProjectUpdaterContext;
import ru.yandex.solomon.roles.RolesContext;
import ru.yandex.solomon.selfmon.GeneralMonitoringContext;
import ru.yandex.solomon.staffOnly.BalancerController;
import ru.yandex.solomon.tracing.TracingContext;


/**
 * @author Alexey Trushkin
 */
@Import({
        HealthContext.class,
        BalancerController.class,
        RequestLoggingFilter.class,
        HttpApiExceptionHandler.class,
        HttpFirewallFilter.class,
        GeneralMonitoringContext.class,
        LazyThreadPoolProvider.class,
        ServiceAuthContext.class,
        TracingContext.class,
        YdbContext.class,
        GrpcApiContext.class,
        AuthContext.class,
        FeatureFlagsContext.class,
        AclDaoContext.class,
        AbcServiceFieldValidator.class,
        StaffClientContext.class,
        RolesContext.class,
        FixContentTypeHeader.class,
        HttpFirewallFilter.class,
        BrokenPipeMuteFilter.class,
        PrivateHttpServer.class,
        TvmContext.class,
        ProjectChangeListenerContext.class,
        ProjectUpdaterContext.class,
        AbcToProjectMappingContext.class,
        GrpcConfigurationContext.class,
})
@Configuration
public class ProjectManagerContext {

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        objectMapper.disable(MapperFeature.AUTO_DETECT_CREATORS);
        objectMapper.disable(MapperFeature.AUTO_DETECT_FIELDS);
        objectMapper.disable(MapperFeature.AUTO_DETECT_GETTERS);
        objectMapper.disable(MapperFeature.AUTO_DETECT_IS_GETTERS);
        return objectMapper;
    }

    @Bean
    public SolomonConfHolder solomonConfHolder() {
        return new SolomonConfHolder();
    }

    @Bean
    public SolomonConfManager solomonConfManager(ServiceProvidersDao serviceProvidersDao, ProjectsDao projectsDao) {
        return new SolomonConfManager(serviceProvidersDao, projectsDao, new InMemoryShardDao(), new InMemoryClustersDao(), new InMemoryServicesDao());
    }

    @Bean
    public SolomonConfWatcher solomonConfWatcher(ThreadPoolProvider threads, List<SolomonConfListener> listeners, SolomonConfManager solomonConfManager) {
        return new SolomonConfWatcher(threads, solomonConfManager, listeners);
    }

}
