package ru.yandex.solomon.project.manager.spring;

import java.util.Optional;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.StaffClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.secrets.SecretProvider;
import ru.yandex.solomon.spring.ConditionalOnBean;
import ru.yandex.solomon.util.SolomonEnv;
import ru.yandex.staff.StaffClient;
import ru.yandex.staff.StaffClientOptions;
import ru.yandex.staff.StaffClients;

import static ru.yandex.solomon.config.OptionalSet.setString;
import static ru.yandex.solomon.config.OptionalSet.setTime;

/**
 * @author Alexey Trushkin
 */
@Configuration
@ConditionalOnBean(StaffClientConfig.class)
@ParametersAreNonnullByDefault
public class StaffClientContext {
    @Bean
    @Nullable
    public StaffClient staffClient(
            ThreadPoolProvider threadPoolProvider,
            SecretProvider secretProvider,
            MetricRegistry registry,
            StaffClientConfig config)
    {
        Optional<String> token = secretProvider.getSecret(config.getOAuthToken());
        if (SolomonEnv.DEVELOPMENT.isActive() && token.isEmpty()) {
            // only in local mode oauth token can be empty
            return null;
        }
        StaffClientOptions.Builder opts = StaffClientOptions.newBuilder().setMetricRegistry(registry);
        setString(opts::setUrl, config.getUrl());
        setTime(opts::setCacheTtl, config.getCacheTtl());
        opts.setOauthToken(token.orElseThrow(() -> new RuntimeException("cannot create StaffClient without token")));
        opts.setExecutor(threadPoolProvider.getExecutorService("CpuLowPriority", ""));
        return StaffClients.create(opts.build());
    }
}
