package ru.yandex.solomon.project.manager.spring;

import java.util.Map;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.passport.tvmauth.NativeTvmClient;
import ru.yandex.passport.tvmauth.TvmApiSettings;
import ru.yandex.passport.tvmauth.TvmClient;
import ru.yandex.solomon.config.protobuf.frontend.TAuthConfig;
import ru.yandex.solomon.config.protobuf.project.manager.JugglerConfig;
import ru.yandex.solomon.config.protobuf.project.manager.SolomonGatewayConfig;
import ru.yandex.solomon.secrets.SecretProvider;

/**
 * @author Alexey Trushkin
 */
@Configuration
@ParametersAreNonnullByDefault
public class TvmContext {

    @Bean(name = "gatewayTvmClient")
    TvmClient serviceTicketTvmClient(SolomonGatewayConfig solomonGatewayConfig, TAuthConfig authConfig, SecretProvider secrets) {
        if (solomonGatewayConfig.getIamAuth()) {
            return null;
        }
        TAuthConfig.TTvmConfig tvmConfig = authConfig.getTvmConfig();
        Optional<String> clientSecret = secrets.getSecret(tvmConfig.getSecret());
        if (clientSecret.isEmpty()) {
            return null;
        }
        return new NativeTvmClient(TvmApiSettings.create()
                .setSelfTvmId(tvmConfig.getClientId())
                .enableServiceTicketChecking()
                .enableServiceTicketsFetchOptions(clientSecret.get(), Map.of("gateway", solomonGatewayConfig.getDestinationTvmClient())));
    }

    @Bean(name = "jugglerTvmClient")
    TvmClient jugglerTvmClient(
            Optional<JugglerConfig> jugglerConfig,
            TAuthConfig authConfig,
            SecretProvider secrets)
    {
        if (jugglerConfig.isEmpty()) {
            return null;
        }
        TAuthConfig.TTvmConfig tvmConfig = authConfig.getTvmConfig();
        Optional<String> clientSecret = secrets.getSecret(tvmConfig.getSecret());
        if (clientSecret.isEmpty()) {
            return null;
        }
        return new NativeTvmClient(TvmApiSettings.create()
                .setSelfTvmId(tvmConfig.getClientId())
                .enableServiceTicketChecking()
                .enableServiceTicketsFetchOptions(clientSecret.get(), Map.of("juggler", jugglerConfig.get().getDestinationTvmClient())));
    }
}
