package ru.yandex.solomon.project.manager.abc.db;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Test;

import ru.yandex.solomon.project.manager.abc.AbcToProjectMapping;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public abstract class AbstractAbcToProjectMappingDaoTest {
    public abstract AbcToProjectMappingDao getDao();

    @Test
    public void upsert() {
        setDefaultProjectSync(new AbcToProjectMapping("abc_1", "solomon"));
        setDefaultProjectSync(new AbcToProjectMapping("abc_2", "solomon"));

        var opt = getMappingSync("abc_1");
        assertTrue(opt.isPresent());
        assertEquals("abc_1", opt.get().abcSlug());
        assertEquals("solomon", opt.get().projectId());

        opt = getMappingSync("abc_2");
        assertTrue(opt.isPresent());
        assertEquals("abc_2", opt.get().abcSlug());
        assertEquals("solomon", opt.get().projectId());

        setDefaultProjectSync(new AbcToProjectMapping("abc_2", "solomon_cloud"));

        opt = getMappingSync("abc_2");
        assertTrue(opt.isPresent());
        assertEquals("abc_2", opt.get().abcSlug());
        assertEquals("solomon_cloud", opt.get().projectId());
    }

    @Test
    public void get() {
        setDefaultProjectSync(new AbcToProjectMapping("abc_1", "solomon"));

        var opt = getMappingSync("abc_1");
        assertTrue(opt.isPresent());

        opt = getMappingSync("abc_2");
        assertTrue(opt.isEmpty());
    }

    private void setDefaultProjectSync(AbcToProjectMapping mapping) {
        join(getDao().setDefaultProject(mapping, ""));
    }

    private Optional<AbcToProjectMapping> getMappingSync(String abcSlug) {
        return join(getDao().getMapping(abcSlug));
    }
}
