package ru.yandex.solomon.project.manager.api.v3.intranet.validators;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Throwables;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.solomon.core.db.dao.ProjectsDao;
import ru.yandex.solomon.core.db.dao.memory.InMemoryProjectsDao;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.core.exceptions.BadRequestException;
import ru.yandex.solomon.core.exceptions.NotFoundException;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class AbcToProjectMappingValidatorTest {

    private AbcToProjectMappingValidator validator;
    private ProjectsDao projectsDao;

    @Before
    public void setUp() {
        projectsDao = new InMemoryProjectsDao();
        validator = new AbcToProjectMappingValidator(projectsDao);
    }

    @Test(expected = BadRequestException.class)
    public void validateGet_exception() {
        validator.validate("");
    }

    @Test
    public void validateGet() {
        validator.validate("solomon");
    }

    @Test
    public void validateSet_exceptionAbc() {
        Exception ex = null;
        try {
            validator.validate("", "").join();
        } catch (Exception e) {
            ex = e;
        }
        assertNotNull(ex);
        assertTrue(Throwables.getRootCause(ex) instanceof BadRequestException);
    }

    @Test
    public void validateSet_exceptionProjectId() {
        Exception ex = null;
        try {
            validator.validate("abc", "").join();
        } catch (Exception e) {
            ex = e;
        }
        assertNotNull(ex);
        assertTrue(Throwables.getRootCause(ex) instanceof BadRequestException);
    }

    @Test
    public void validateSet_exceptionProjectIdNotFound() {
        Exception ex = null;
        try {
            validator.validate("abc", "solomon").join();
        } catch (Exception e) {
            ex = e;
        }
        assertNotNull(ex);
        assertTrue(Throwables.getRootCause(ex) instanceof NotFoundException);
    }

    @Test
    public void validateSet_exceptionDifferentAbc() {
        Exception ex = null;
        try {
            projectsDao.insert(Project.newBuilder()
                    .setId("solomon")
                    .setName("new")
                    .setOwner("my")
                    .setAbcService("another")
                    .build())
                    .join();
            validator.validate("abc", "solomon").join();
        } catch (Exception e) {
            ex = e;
        }
        assertNotNull(ex);
        assertTrue(Throwables.getRootCause(ex) instanceof BadRequestException);
    }

    @Test
    public void validateSet() {
        projectsDao.insert(Project.newBuilder()
                .setId("solomon")
                .setName("new")
                .setOwner("my")
                .setAbcService("abc")
                .build())
                .join();
        validator.validate("abc", "solomon").join();
    }
}
