#pragma once

#include <solomon/services/slicer/api/slicer_service.grpc.pb.h>
#include <solomon/services/slicer/lib/assignment_manager/events.h>

#include <solomon/libs/cpp/grpc/server/service.h>

namespace NSolomon::NSlicer::NApi {

SOLOMON_RPC_HANDLER(yandex::monitoring::slicer::SlicerService, GetAllAssignments) {
public:
    explicit TGetAllAssignmentsHandler(NActors::TActorId serviceManager);

public:
    void Handle(const NActors::TActorContext&) override;

    STATEFN(StateFunc) {
        switch (ev->GetTypeRewrite()) {
            hFunc(TAssignmentEvents::TGetAllAssignmentsResult, OnAssignments);
            hFunc(TAssignmentEvents::TGetAllAssignmentsForwardedResponse, OnForwardedAssignments);
        }
    }

    void OnAssignments(TAssignmentEvents::TGetAllAssignmentsResult::TPtr& ev);
    void OnForwardedAssignments(TAssignmentEvents::TGetAllAssignmentsForwardedResponse::TPtr& ev);

private:
    NActors::TActorId ServiceManager_;
};

SOLOMON_RPC_HANDLER(yandex::monitoring::slicer::SlicerService, GetSlicesByHost) {
public:
    explicit TGetSlicesByHostHandler(NActors::TActorId serviceManager);

public:
    void Handle(const NActors::TActorContext&) override;

    STATEFN(StateFunc) {
        switch (ev->GetTypeRewrite()) {
            hFunc(TAssignmentEvents::TGetSlicesByHostResult, OnSlices);
            hFunc(TAssignmentEvents::TGetSlicesByHostForwardedResponse, OnForwardedSlices);
        }
    }

    void OnSlices(TAssignmentEvents::TGetSlicesByHostResult::TPtr& ev);
    void OnForwardedSlices(TAssignmentEvents::TGetSlicesByHostForwardedResponse::TPtr& ev);

private:
    NActors::TActorId ServiceManager_;
};

SOLOMON_RPC_HANDLER(yandex::monitoring::slicer::SlicerService, MoveShard) {
public:
    explicit TMoveShardHandler(NActors::TActorId serviceManager);

public:
    void Handle(const NActors::TActorContext&) override;

    STATEFN(StateFunc) {
        switch (ev->GetTypeRewrite()) {
            hFunc(TAssignmentEvents::TMoveShardResponse, OnMoveShardResponse);
        }
    }

    void OnMoveShardResponse(TAssignmentEvents::TMoveShardResponse::TPtr& ev);

private:
    NActors::TActorId ServiceManager_;
};

} // namespace NSolomon::NSlicer::NApi
