#include "service.h"

#include "assignments.h"

namespace NSolomon::NSlicer::NApi {

TSlicerService::TSlicerService(
        NActors::TActorSystem& actorSystem,
        NMonitoring::TMetricRegistry& registry,
        ui32 executorPool,
        NActors::TActorId serviceManager)
    : TService(actorSystem, registry, executorPool)
    , ServiceManager_{serviceManager}
{}

void TSlicerService::InitHandlers(grpc::ServerCompletionQueue* cq) {
    RegisterHandler<TGetAllAssignmentsHandler>(cq, ServiceManager_);
    RegisterHandler<TGetSlicesByHostHandler>(cq, ServiceManager_);
    RegisterHandler<TMoveShardHandler>(cq, ServiceManager_);
}

} // namespace NSolomon::NSlicer::NApi
