#pragma once

#include <solomon/services/slicer/config/slicer_config.pb.h>
#include <solomon/services/slicer/lib/db/assignment_dao.h>
#include <solomon/services/slicer/lib/db/ydb_service_config_dao.h>

#include <solomon/libs/cpp/distributed_lock/lock.h>
#include <solomon/libs/cpp/clients/slicer/slicer_client.h>

#include <library/cpp/actors/core/actor.h>

namespace NSolomon::NSlicer::NApi {

THolder<NActors::IActor> CreateAssignmentManager(
        TString serviceName,
        const yandex::monitoring::slicer::SlicerConfig& config,
        NActors::TActorId clusterMembershipActor,
        IDistributedLockPtr lock,
        NSolomon::NSlicerClient::ISlicerClusterClientPtr slicerClients,
        NMonitoring::TMetricRegistry& registry,
        TString clientId,
        NDb::IAssignmentDaoPtr assnDao,
        std::shared_ptr<NDb::IServiceConfigDao> serviceDao);

} // namespace NSolomon::NSlicer::NApi
