#pragma once

#include <solomon/services/slicer/config/slicer_config.pb.h>
#include <solomon/services/slicer/lib/db/assignment_dao.h>
#include <solomon/services/slicer/lib/db/ydb_service_config_dao.h>

#include <solomon/libs/cpp/distributed_lock/lock.h>
#include <solomon/libs/cpp/clients/slicer/slicer_client.h>
#include <solomon/libs/cpp/ydb/driver.h>

#include <library/cpp/actors/core/actor.h>

namespace NSolomon::NSlicer {

using TClusterMembershipFactory = std::function<THolder<NActors::IActor>(
    const TString&,
    const yandex::monitoring::slicer::SlicerConfig&,
    NMonitoring::TMetricRegistry&)>;

std::unique_ptr<NActors::IActor> CreateServiceManager(
    const yandex::monitoring::slicer::SlicerConfig& config,
    NYdb::TDriver ydbDriver,
    TClusterMembershipFactory clusterMembershipFactory,
    NSolomon::NSlicerClient::ISlicerClusterClientPtr slicerClients,
    NMonitoring::TMetricRegistry& registry,
    TString clientId,
    NDb::IAssignmentDaoPtr assnDao,
    std::shared_ptr<NDb::IServiceConfigDao> serviceDao);

} // namespace NSolomon::NSlicer
