LIBRARY()

OWNER(g:solomon)

SRCS(
    assignment_manager.cpp
    events.cpp
    private_events.cpp
    request_ctx_fwd_get_all_assn.cpp
    request_ctx_fwd_get_slices_by_host.cpp
    request_ctx_load_info.cpp
    service_manager.cpp
)

PEERDIR(
    solomon/services/slicer/config
    solomon/services/slicer/lib/balancer
    solomon/services/slicer/lib/common
    solomon/services/slicer/lib/db
    solomon/services/slicer/lib/events

    solomon/libs/cpp/actors/events
    solomon/libs/cpp/actors/util
    solomon/libs/cpp/clients/load_info
    solomon/libs/cpp/cluster_map
    solomon/libs/cpp/cluster_membership
    solomon/libs/cpp/coordination/leader_election
    solomon/libs/cpp/distributed_lock
    solomon/libs/cpp/error_or
    solomon/libs/cpp/grpc/client
    solomon/libs/cpp/grpc/server
    solomon/libs/cpp/logging
    solomon/libs/cpp/clients/slicer
    solomon/libs/cpp/slices
    solomon/libs/cpp/string_map
    solomon/libs/cpp/ydb

    library/cpp/actors/core
    library/cpp/containers/absl_flat_hash
)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(assignment_manager.h)

END()
