#pragma once

#include <solomon/services/slicer/lib/common/assignments.h>
#include <solomon/services/slicer/lib/common/host_reported.h>
#include <solomon/services/slicer/lib/common/reassignment_type.h>
#include <solomon/services/slicer/lib/db/service_config.h>
#include <solomon/services/slicer/lib/events/event_slots.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/clients/slicer/api_types.h>
#include <solomon/libs/cpp/cluster_membership/events.h>

#include <library/cpp/actors/core/actor.h>

namespace NSolomon::NSlicer {

enum class EMergeStatus {
    Unknown = 0,
    HappyPath,
    TooFewSlices,
    KeyChurnExhausted,
};

struct TBalanceStats {
    TDuration Duration;
    size_t MoveIterations;
    double MoveKeyChurn;
    size_t NumOfMovedSlices;
    size_t MergeIterations;
    double MergeKeyChurn;
    size_t NumOfMergedSlices;
    EMergeStatus MergeStatus;
    size_t SplitIterations;
    size_t SplitCount;
    double MeanLoadPercent; // percentage of value Load/Budget
    double LoadRSDPercent; // relative standard deviation of load percentage
};

class TBalancerEvents: private NSolomon::TEventSlot<EEventSpace::Slicer, ES_BALANCER> {
    enum {
        Balance = SpaceBegin,
        BalanceResult,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TBalance: public NActors::TEventLocal<TBalance, Balance> {
        TAssignments Assignments;

        explicit TBalance(TAssignments&& assn)
            : Assignments{std::move(assn)}
        {
        }
    };

    struct TBalanceResult: public NActors::TEventLocal<TBalanceResult, BalanceResult> {
        TAssignments Assignments;
        TStringMap<NApi::TSlices> HostToSlices;
        TBalanceStats Stats;

        TBalanceResult(TAssignments&& assn, TStringMap<NApi::TSlices>&& hostToSlices, TBalanceStats&& stats)
            : Assignments{std::move(assn)}
            , HostToSlices{std::move(hostToSlices)}
            , Stats{std::move(stats)}
        {
        }
    };
};

std::unique_ptr<NActors::IActor> CreateBalancer(
        const TString& service,
        NActors::TActorId replyTo,
        EReassignmentType reassignmentType,
        NSolomon::NClusterMembership::TClusterMembershipState clusterMembership,
        TStringMap<NSolomon::NSlicer::NApi::TSlices> hostToSlices,
        THostReportedInfo hostReported,
        NDb::TServiceConfig serviceSettings);

} // namespace NSolomon::NSlicer
