#pragma once

#include <solomon/libs/cpp/clients/slicer/api_types.h>
#include <solomon/libs/cpp/cluster_membership/events.h>
#include <solomon/libs/cpp/string_map/string_map.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>

#include <util/generic/hash.h>

#include <map>

namespace NSolomon::NSlicer {

using TAssignments = std::map<NApi::TSlice, NApi::THosts, NApi::TSliceTransparentComparator>;

struct TAssignmentsDiff {
    TAssignments Added;
    TVector<NApi::TSlice> Removed;
};

TAssignmentsDiff DiffAssignments(const TAssignments& oldAssn, const TAssignments& newAssn);

TAssignments ConstructAssignmentsFromHostToSlices(
        const TStringMap<NApi::TSlices>& hostToSlices);

TStringMap<NApi::TSlices> ConstructHostToSlicesFromAssignments(TAssignments& assn);

void MoveSlicesFromDeadNodes(
        const TVector<TStringBuf>& deadNodes,
        const TVector<TStringBuf>& assignableNodes,
        TStringMap<NApi::TSlices>& hostToSlices);

void RebalanceKeysUniformly(
        const TVector<TStringBuf>& assignableNodes,
        TStringMap<NApi::TSlices>& hostToSlices);

void CheckAssignmentsForValidity(const TAssignments& assn);

/**
 * doesn't throw
 */
bool CheckAssignmentsForValiditySafe(const TAssignments& assn);

} // namespace NSolomon::NSlicer

IOutputStream& operator<<(IOutputStream& os, const NSolomon::NSlicer::TAssignments& assn);
std::ostream& operator<<(std::ostream& s, const NSolomon::NSlicer::TAssignments& assn);

IOutputStream& operator<<(IOutputStream& os, const NSolomon::NSlicer::TAssignmentsDiff& diff);
std::ostream& operator<<(std::ostream& s, const NSolomon::NSlicer::TAssignmentsDiff& diff);
