#pragma once

#include <solomon/libs/cpp/clients/slicer/api_types.h>
#include <solomon/libs/cpp/cluster_membership/events.h>
#include <solomon/libs/cpp/string_map/string_map.h>

namespace NSolomon::NSlicer {

struct TLoadInfo {
    //    ShardState State;
    //    repeated fixed64 uptime_millis;
    ui64 CpuTimeNanos{0};
    ui64 MemoryBytes{0};
    ui64 NetworkBytes{0};

    bool operator == (const TLoadInfo& other) const {
        return CpuTimeNanos == other.CpuTimeNanos && MemoryBytes == other.MemoryBytes && NetworkBytes == other.NetworkBytes;
    }
    bool operator != (const TLoadInfo& other) const {
        return !(*this == other);
    }
};

struct THostReportedInfo {
    // TODO(ivanzhukov): remove later, 'cause slicer is independent of an application logic
    TStringMap<std::set<NApi::TNumId>> HostToNumIds;
    // TODO(ivanzhukov): looks like a redundant struct, remove later
    TStringMap<NApi::TSlices> HostToSlices;
    absl::flat_hash_map<NApi::TNumId, TLoadInfo> ShardsInfo;
    TStringMap<TLoadInfo> HostsInfo;
};

} // namespace NSolomon::NSlicer
