#pragma once

#include "host_reported.h"

#include <solomon/libs/cpp/clients/slicer/api_types.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_set.h>

namespace NSolomon::NSlicer {

struct TSliceWithLoad {
    NApi::TSlice Slice;
    TLoadInfo Load;

    TSliceWithLoad(NApi::TSlice slice, TLoadInfo load)
            : Slice{slice}
            , Load{std::move(load)}
    {
    }

    bool operator==(const TSliceWithLoad& other) const noexcept {
        return Slice == other.Slice;
    }

    bool operator<(const TSliceWithLoad& other) const noexcept {
        return Slice < other.Slice;
    }
};

struct TSliceWithLoadAndHost {
    NApi::TSlice Slice;
    TLoadInfo Load;
    TStringBuf Host;

    TSliceWithLoadAndHost(NApi::TSlice slice, TLoadInfo loadInfo, TStringBuf host)
        : Slice{slice}
        , Load{std::move(loadInfo)}
        , Host{host}
    {
    }
};

struct TSliceWithLoadHash {
    using is_transparent = void;

    ui64 operator()(const NApi::TSlice& slice) const noexcept {
        return THash<NSolomon::NSlicer::NApi::TSlice>{}(slice);
    }

    ui64 operator()(const TSliceWithLoad& slice) const noexcept {
        return THash<NSolomon::NSlicer::NApi::TSlice>{}(slice.Slice);
    }
};

struct TSliceWithLoadKeyEqual {
    using is_transparent = void;

    bool operator()(const TSliceWithLoad& sliceWithLoad, const NApi::TSlice& slice) const noexcept {
        return sliceWithLoad.Slice == slice;
    }

    bool operator()(const TSliceWithLoad& left, const TSliceWithLoad& right) const noexcept {
        return left.Slice == right.Slice;
    }
};

// Used in balancing. When balancing, we need to quickly move a slice from one host to another, hence a hash set
using THostToSliceSet = TStringMap<absl::flat_hash_set<TSliceWithLoad, TSliceWithLoadHash, TSliceWithLoadKeyEqual>>;
// Used in TAssignmentManager to send a sorted response to a client and to show a sorted result in the Viewer
using THostToSortedSlices = TStringMap<std::set<TSliceWithLoad>>;

} // namespace NSolomon::NSlicer
