#include <solomon/services/slicer/lib/config/config.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/resource/resource.h>

#include <util/system/tempfile.h>

using namespace NSolomon::NSlicer;
using yandex::monitoring::slicer::SlicerConfig;

void ValidateConfig(TStringBuf name) {
    TString configText = NResource::Find(name);
    ASSERT_TRUE(!configText.Empty());

    TTempFileHandle tmp;
    tmp.Write(configText.data(), configText.size());
    tmp.FlushData();

    SlicerConfig config = ParseTextProto(tmp.Name());
    Validate(config);
}

TEST(TConfigTest, DevConfValid) {
    ValidateConfig("slicer.dev.conf");
}
