#include "assignment.h"

#include <util/stream/output.h>

namespace NSolomon::NSlicer::NDb {
namespace {

template <typename TStream>
void Out(TStream& os, const TAssignment& obj) {
    os << "service: " << obj.Service
       << ", cluster: " << obj.Cluster
       << ", dc: " << obj.Dc
       << ", host: " << obj.Host
       << ", version: " << obj.Version
       << ", slices: ["
        ;

    for (int i = 0; i < obj.HostSlices.slices_size(); i += 2) {
        if (i > 0) {
            os << ", ";
        }

        os << '[' << obj.HostSlices.slices(i) << "; " << obj.HostSlices.slices(i + 1) << ']';
    }

    os << ']';
}

} // namespace

IOutputStream& operator<<(IOutputStream& os, const NSolomon::NSlicer::NDb::TAssignment& obj) {
    NSolomon::NSlicer::NDb::Out(os, obj);
    return os;
}

std::ostream& operator<<(std::ostream& os, const NSolomon::NSlicer::NDb::TAssignment& obj) {
    NSolomon::NSlicer::NDb::Out(os, obj);
    return os;
}

} // namespace NSolomon::NSlicer::NDb
