#pragma once

#include <solomon/services/slicer/lib/db/proto/assignment.pb.h>

#include <solomon/libs/cpp/clients/slicer/api_types.h>

#include <google/protobuf/util/message_differencer.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NSolomon::NSlicer::NDb {

class TAssignment {
public:
    TString Service;
    TString Cluster;
    TString Dc;
    TString Host;
    yandex::monitoring::slicer::HostSlices HostSlices;
    ui32 Version;

    TAssignment() = default;

    TAssignment(
            TString service,
            TString cluster,
            TString dc,
            TString host,
            const NSlicer::NApi::TSlices& slices,
            ui32 version)
        : Service{std::move(service)}
        , Cluster{std::move(cluster)}
        , Dc{std::move(dc)}
        , Host{std::move(host)}
        , Version{version}
    {
        for (const auto& slice: slices) {
            HostSlices.add_slices(slice.Start);
            HostSlices.add_slices(slice.End);
        }
    }

    bool operator==(const TAssignment& other) const noexcept {
        return std::tie(Service, Cluster, Dc, Host, Version) ==
                std::tie(other.Service, other.Cluster, other.Dc, other.Host, other.Version) &&
            google::protobuf::util::MessageDifferencer::Equals(HostSlices, other.HostSlices);
    }
};

IOutputStream& operator<<(IOutputStream& os, const NSolomon::NSlicer::NDb::TAssignment& obj);
std::ostream& operator<<(std::ostream& os, const NSolomon::NSlicer::NDb::TAssignment& obj);

} // namespace NSolomon::NDb::NModel
