#pragma once

#include "assignment.h"

#include <library/cpp/threading/future/fwd.h>
#include <library/cpp/monlib/metrics/fwd.h>

#include <util/generic/vector.h>

namespace NYdb::NTable {
    class TTableClient;
} // namespace NYdb::NTable

namespace NSolomon::NSlicer::NDb {

using TAsyncVoid = NThreading::TFuture<void>;
using TAsyncAssignments = NThreading::TFuture<TVector<TAssignment>>;

class IAssignmentDao {
public:
    virtual ~IAssignmentDao() = default;

    virtual TAsyncVoid CreateTable() = 0;

    virtual TAsyncAssignments LoadAll() const = 0;

    virtual TAsyncAssignments Load(const TString& service, const TString& cluster, const TString& dc) = 0;

    virtual TAsyncVoid Update(const TVector<TAssignment>& update) = 0;
};

using IAssignmentDaoPtr = std::shared_ptr<IAssignmentDao>;

IAssignmentDaoPtr CreateYdbAssignmentDao(
        TString tablePath,
        std::shared_ptr<NYdb::NTable::TTableClient> client,
        NMonitoring::TMetricRegistry& registry);

} // namespace NSolomon::NSlicer::NDb
