#include "service_config.h"

#include <util/stream/output.h>

#include <iostream>

namespace {

template <typename TStream>
void Write(TStream& s, const NSolomon::NSlicer::NDb::TServiceConfig& config) {
     s << "{Service: \"" << config.Service << '"'
            << ", Cluster: \"" << config.Cluster << '"'
            << ", Dc: \"" << config.Dc << '"'
            << ", IsFrozen: \"" << config.IsFrozen << '"'
            << '}';
}

} // namespace

std::ostream& operator<<(std::ostream& os, const NSolomon::NSlicer::NDb::TServiceConfig& config) {
    Write(os, config);
    return os;
}

IOutputStream& operator<<(IOutputStream& os, const NSolomon::NSlicer::NDb::TServiceConfig& config) {
    Write(os, config);
    return os;
}
