#pragma once

#include "service_config.h"

#include <library/cpp/monlib/metrics/fwd.h>
#include <library/cpp/threading/future/fwd.h>

#include <optional>

namespace NYdb::NTable {
class TTableClient;
} // namespace NYdb::NTable

namespace NSolomon::NSlicer::NDb {

using TAsyncVoid = NThreading::TFuture<void>;
using TAsyncServiceConfig = NThreading::TFuture<std::optional<TServiceConfig>>;
using TAsyncServiceConfigs = NThreading::TFuture<TVector<TServiceConfig>>;

class IServiceConfigDao {
public:
    virtual ~IServiceConfigDao() = default;

    virtual TAsyncVoid CreateTable() = 0;

    virtual TAsyncServiceConfigs LoadAll() const = 0;

    virtual TAsyncServiceConfig Load(const TServiceConfigKey& key) = 0;

    virtual TAsyncVoid Update(const TServiceConfig& serviceConfig) = 0;
};

std::shared_ptr<IServiceConfigDao> CreateYdbServiceConfigDao(
        TString tablePath,
        std::shared_ptr<NYdb::NTable::TTableClient> client,
        NMonitoring::TMetricRegistry& registry);

} // namespace NSolomon::NSlicer::NDb
