#pragma once

#include "host_status.h"

#include <solomon/libs/cpp/selfmon/selfmon.h>

#include <library/cpp/actors/core/actor.h>

namespace NSolomon::NHttp {
    class THttpServer;
} // namespace NSolomon::NHttp

namespace NSolomon::NSlicer {

inline void InitSlicerSpecificHttpHandlers(NActors::TActorSystem& actorSystem, NActors::TActorId assignmentManagerId) {
    NSelfMon::RegisterPage(actorSystem, "/hosts", "Hosts", NSolomon::NSlicer::HostsPage(assignmentManagerId));
    NSelfMon::RegisterPage(actorSystem, "/findShard", "Find Shard", NSolomon::NSlicer::FindShardHostPage(assignmentManagerId));
    NSelfMon::RegisterPage(actorSystem, "/moveShard", "Move Shard", NSolomon::NSlicer::MoveShardPage(assignmentManagerId));
}

} // namespace NSolomon::NSlicer
