package ru.yandex.stockpile;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.config.protobuf.stockpile.TStockpileConfig;
import ru.yandex.solomon.main.SpringContexts;
import ru.yandex.stockpile.server.StockpileMainContext;

import static ru.yandex.solomon.config.SolomonConfigs.parseConfigWithoutInclude;

/**
 * @author Sergey Polovko
 */
@RunWith(Parameterized.class)
public class StockpileMainContextTest {

    @Rule
    public Timeout timeout = Timeout.builder()
            .withLookingForStuckThread(true)
            .withTimeout(1, TimeUnit.MINUTES)
            .build();

    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters(name = "{0}")
    public static String[] configs() {
        return new String[]{
                "configs/dev/stockpile.dev.conf",
                "configs/testing/stockpile.conf",
                "configs/prestable/stockpile.conf",
                "configs/production/stockpile.sas.conf",
                "configs/production/stockpile.vla.conf",
                "configs/cloud-preprod/stockpile.conf",
                "configs/cloud-preprod/ig/stockpile.a.conf",
                "configs/cloud-preprod/ig/stockpile.b.conf",
                "configs/cloud-prod/stockpile.vla.conf",
                "configs/cloud-prod/stockpile.sas.conf",
                "configs/israel/stockpile.a.conf",
                "configs/israel/stockpile.b.conf",
        };
    }

    @Test
    public void testConfiguration() {
        if (!Files.exists(Path.of(configFile))) {
            Assert.fail("cannot find file " + configFile + ", CWD: " + Path.of(".").toAbsolutePath().normalize());
        }

        var config = parseConfigWithoutInclude(configFile, TStockpileConfig.getDefaultInstance());
        Assert.assertNotEquals(TStockpileConfig.getDefaultInstance(), config);

        try (var ctx = SpringContexts.createSimple(StockpileMainContext.class, config)) {
            Assert.assertEquals(config, ctx.getBean(TStockpileConfig.class));
        }
    }
}
