package ru.yandex.stockpile.api.grpc;

import java.io.IOException;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;

import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
public class LogHistogramParser {

    public static LogHistogram parse(CodedInputStream input) {
        return parse(input, LogHistogram.newInstance());
    }

    public static LogHistogram parse(CodedInputStream input, LogHistogram builder) {
        try {
            int tag;
            while ((tag = input.readTag()) != 0) {
                if (tag == 9) {
                    builder.addBucket(input.readDouble());
                    continue;
                }

                switch (WireFormat.getTagFieldNumber(tag)) {
                    case ru.yandex.solomon.model.protobuf.LogHistogram.BUCKETS_FIELD_NUMBER:
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            builder.addBucket(input.readDouble());
                        }
                        input.popLimit(limit);
                        break;
                    case ru.yandex.solomon.model.protobuf.LogHistogram.ZEROES_FIELD_NUMBER:
                        builder.setCountZero(input.readUInt32());
                        break;
                    case ru.yandex.solomon.model.protobuf.LogHistogram.START_POWER_FIELD_NUMBER:
                        builder.setStartPower(input.readSInt32());
                        break;
                    case ru.yandex.solomon.model.protobuf.LogHistogram.MAX_BUCKETS_SIZE_FIELD_NUMBER:
                        builder.setMaxBucketsSize(input.readSInt32());
                        break;
                    case ru.yandex.solomon.model.protobuf.LogHistogram.BASE_FIELD_NUMBER:
                        builder.setBase(input.readDouble());
                        break;
                    default:
                        if (!input.skipField(tag)) {
                            return builder.build();
                        }
                        break;
                }
            }
            return builder.build();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
