package ru.yandex.stockpile.api.grpc;

import java.io.IOException;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;

import ru.yandex.solomon.model.protobuf.MetricId;
import ru.yandex.stockpile.client.shard.StockpileLocalId;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricIdParser {
    public static long parseLocalId(CodedInputStream input) {
        long localId = 0;
        try {
            loop:
            do {
                int tag = input.readTag();
                if (tag == 0) {
                    break;
                }

                switch (WireFormat.getTagFieldNumber(tag)) {
                    case MetricId.LOCAL_ID_FIELD_NUMBER:
                        localId = input.readFixed64();
                        break;
                    default:
                        if (!input.skipField(tag)) {
                            break loop;
                        }
                        break;
                }
            } while (true);
            StockpileLocalId.validate(localId);
            return localId;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
