package ru.yandex.stockpile.api.grpc;

import ru.yandex.solomon.util.exception.RpcException;
import ru.yandex.stockpile.api.EStockpileStatusCode;

/**
 * @author Vladimir Gordiychuk
 */
// TODO: move to another package?
public class StockpileRuntimeException extends RuntimeException implements RpcException {
    private final EStockpileStatusCode statusCode;
    private final boolean writeStackTrace;

    public StockpileRuntimeException(EStockpileStatusCode statusCode, String message, Throwable cause) {
        super(statusCode.name() + ": " + message, cause);
        this.statusCode = statusCode;
        this.writeStackTrace = true;
    }

    public StockpileRuntimeException(EStockpileStatusCode statusCode, Throwable cause) {
        super(statusCode.name(), cause);
        this.statusCode = statusCode;
        this.writeStackTrace = true;
    }

    public StockpileRuntimeException(EStockpileStatusCode statusCode, String message) {
        super(statusCode.name() + ": " + message);
        this.statusCode = statusCode;
        this.writeStackTrace = true;
    }

    public StockpileRuntimeException(EStockpileStatusCode statusCode, String message, boolean writableStackTrace) {
        super(statusCode.name() + ": " + message, null, true, writableStackTrace);
        this.statusCode = statusCode;
        this.writeStackTrace = writableStackTrace;
    }

    public StockpileRuntimeException(EStockpileStatusCode statusCode) {
        super(statusCode.name());
        this.statusCode = statusCode;
        this.writeStackTrace = true;
    }

    public StockpileRuntimeException(EStockpileStatusCode statusCode, boolean writeStackTrace) {
        super(statusCode.name());
        this.statusCode = statusCode;
        this.writeStackTrace = writeStackTrace;
    }

    public EStockpileStatusCode getStockpileStatusCode() {
        return statusCode;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        if (writeStackTrace) {
            return super.fillInStackTrace();
        } else {
            // do not fill stacktrace
            return this;
        }
    }

    @Override
    public boolean logOnRpcServer() {
        return writeStackTrace;
    }
}
