package ru.yandex.stockpile.api.grpc;

import java.io.IOException;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;

import ru.yandex.solomon.model.type.SummaryDouble;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryDoubleParser {
    public static SummaryDouble parse(CodedInputStream input) {
        return parse(input, SummaryDouble.newInstance());
    }

    public static SummaryDouble parse(CodedInputStream input, SummaryDouble summary) {
        try {
            int tag;
            summary.setMax(0).setMin(0);
            while ((tag = input.readTag()) != 0) {
                switch (WireFormat.getTagFieldNumber(tag)) {
                    case ru.yandex.solomon.model.protobuf.SummaryDouble.COUNT_FIELD_NUMBER:
                        summary.setCount(input.readUInt64());
                        break;
                    case ru.yandex.solomon.model.protobuf.SummaryDouble.SUM_FIELD_NUMBER:
                        summary.setSum(input.readDouble());
                        break;
                    case ru.yandex.solomon.model.protobuf.SummaryDouble.MAX_FIELD_NUMBER:
                        summary.setMax(input.readDouble());
                        break;
                    case ru.yandex.solomon.model.protobuf.SummaryDouble.MIN_FIELD_NUMBER:
                        summary.setMin(input.readDouble());
                        break;
                    case ru.yandex.solomon.model.protobuf.SummaryDouble.LAST_FIELD_NUMBER:
                        summary.setLast(input.readDouble());
                        break;
                    default:
                        if (!input.skipField(tag)) {
                            return summary;
                        }
                        break;
                }
            }
            return summary;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
