package ru.yandex.stockpile.api.grpc;

import java.io.IOException;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;

import ru.yandex.monlib.metrics.summary.ImmutableSummaryInt64Snapshot;
import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.model.protobuf.SummaryInt64;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryInt64Parser {

    public static SummaryInt64Snapshot parse(CodedInputStream input) {
        try {
            long count = 0;
            long sum = 0;
            long min = 0;
            long max = 0;
            long last = 0;

            loop:
            do {
                int tag = input.readTag();
                if (tag == 0) {
                    break;
                }

                switch (WireFormat.getTagFieldNumber(tag)) {
                    case SummaryInt64.COUNT_FIELD_NUMBER:
                        count = input.readUInt64();
                        break;
                    case SummaryInt64.SUM_FIELD_NUMBER:
                        sum = input.readSInt64();
                        break;
                    case SummaryInt64.MAX_FIELD_NUMBER:
                        max = input.readSInt64();
                        break;
                    case SummaryInt64.MIN_FIELD_NUMBER:
                        min = input.readSInt64();
                        break;
                    case SummaryInt64.LAST_FIELD_NUMBER:
                        last = input.readSInt64();
                        break;
                    default:
                        if (!input.skipField(tag)) {
                            break loop;
                        }
                        break;
                }
            } while (true);
            return new ImmutableSummaryInt64Snapshot(count, sum, min, max, last);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
