package ru.yandex.stockpile.api.grpc;

import java.io.IOException;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.WireFormat;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.stockpile.api.DeleteMetricDataRequest;
import ru.yandex.stockpile.api.DeleteMetricRequest;
import ru.yandex.stockpile.api.TCommandRequest;
import ru.yandex.stockpile.api.TCompressedWriteRequest;
import ru.yandex.stockpile.api.grpc.handler.LogEntryAppender;
import ru.yandex.stockpile.server.shard.StockpileWriteRequest;

/**
 * @author Vladimir Gordiychuk
 */
public class TCommandRequestParser {
    public static int parse(StockpileWriteRequest.Builder builder, AggrPoint point, CodedInputStream input) {
        int records = 0;
        try {
            boolean done = false;
            while (!done) {
                int tag = input.readTag();
                if (tag == 0) {
                    break;
                }

                switch (WireFormat.getTagFieldNumber(tag)) {
                    case TCommandRequest.WRITE_FIELD_NUMBER: {
                        int length = input.readRawVarint32();
                        final int oldLimit = input.pushLimit(length);

                        records += TWriteRequestParser.parse(builder, point, input);

                        input.checkLastTagWas(0);
                        input.popLimit(oldLimit);
                        break;
                    }
                    case TCommandRequest.COMPRESSEDWRITE_FIELD_NUMBER: {
                        var command = input.readMessage(TCompressedWriteRequest.parser(), ExtensionRegistry.getEmptyRegistry());
                        LogEntryAppender.appendCompressedWrite(builder, command);
                        records += 1;
                        break;
                    }
                    case TCommandRequest.DELETE_METRIC_FIELD_NUMBER: {
                        var command = input.readMessage(DeleteMetricRequest.parser(), ExtensionRegistry.getEmptyRegistry());
                        LogEntryAppender.appendDelete(builder, command);
                        records += 1;
                        break;
                    }
                    case TCommandRequest.DELETE_METRIC_DATA_FIELD_NUMBER: {
                        var command = input.readMessage(DeleteMetricDataRequest.parser(), ExtensionRegistry.getEmptyRegistry());
                        LogEntryAppender.appendDeleteData(builder, command);
                        records += 1;
                        break;
                    }
                    default:
                        if (!input.skipField(tag)) {
                            done = true;
                        }
                        break;
                }
            }
            return records;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
