package ru.yandex.stockpile.api.grpc;

import java.util.Iterator;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.stockpile.api.TPoint;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class TPointAggrGraphDataIterator extends AggrGraphDataListIterator {
    private final Iterator<TPoint> it;
    private final int count;

    public TPointAggrGraphDataIterator(int columnSetMask, List<TPoint> points) {
        super(columnSetMask);
        this.it = points.iterator();
        this.count = points.size();
    }

    @Override
    public int estimatePointsCount() {
        return count;
    }

    @Override
    public boolean next(AggrPoint target) {
        if (!it.hasNext()) {
            return false;
        }

        TPoint point = it.next();
        TPointConverters.fromProto(columnSetMask(), point, target);
        return true;
    }
}
