package ru.yandex.stockpile.api.grpc;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.point.column.ValueColumn;
import ru.yandex.solomon.model.protobuf.HistogramConverter;
import ru.yandex.solomon.model.protobuf.LogHistogramConverter;
import ru.yandex.solomon.model.protobuf.SummaryConverter;
import ru.yandex.stockpile.api.TPoint;
import ru.yandex.stockpile.api.TPointOrBuilder;

/**
 * @author Vladimir Gordiychuk
 */
public class TPointConverters {

    public static void fromProto(int mask, TPointOrBuilder point, AggrPoint target) {
        if (StockpileColumn.TS.isInSet(mask)) {
            target.setTsMillis(point.getTimestampsMillis());
        }

        if (StockpileColumn.VALUE.isInSet(mask)) {
            target.setValue(point.getDoubleValue(), ValueColumn.DEFAULT_DENOM);
        }

        if (StockpileColumn.LONG_VALUE.isInSet(mask)) {
            target.setLongValue(point.getLongValue());
        }

        if (StockpileColumn.LOG_HISTOGRAM.isInSet(mask)) {
            target.setLogHistogram(LogHistogramConverter.fromProto(point.getLogHistogram()));
        }

        if (StockpileColumn.MERGE.isInSet(mask)) {
            target.setMerge(point.getMerge());
        }

        if (StockpileColumn.COUNT.isInSet(mask)) {
            target.setCount(point.getCount());
        }

        if (StockpileColumn.STEP.isInSet(mask)) {
            target.setStepMillis(point.getStepMillis());
        }

        if (StockpileColumn.HISTOGRAM.isInSet(mask)) {
            target.setHistogram(HistogramConverter.fromProto(point.getHistogram()));
        }

        if (StockpileColumn.ISUMMARY.isInSet(mask)) {
            target.setSummaryInt64(SummaryConverter.fromProto(point.getSummaryInt64()));
        }

        if (StockpileColumn.DSUMMARY.isInSet(mask)) {
            target.setSummaryDouble(SummaryConverter.fromProto(point.getSummaryDouble()));
        }
    }

    public static void toProto(int mask, AggrPoint point, TPoint.Builder target) {
        if (StockpileColumn.TS.isInSet(mask)) {
            target.setTimestampsMillis(point.getTsMillis());
        }

        if (StockpileColumn.VALUE.isInSet(mask)) {
            target.setDoubleValue(point.getValueDivided());
        }

        if (StockpileColumn.LONG_VALUE.isInSet(mask)) {
            target.setLongValue(point.longValue);
        }

        if (StockpileColumn.MERGE.isInSet(mask)) {
            target.setMerge(point.isMerge());
        }

        if (StockpileColumn.COUNT.isInSet(mask)) {
            target.setCount(Math.toIntExact(point.getCount()));
        }

        if (StockpileColumn.STEP.isInSet(mask)) {
            target.setStepMillis(point.getStepMillis());
        }

        if (StockpileColumn.LOG_HISTOGRAM.isInSet(mask)) {
            target.setLogHistogram(LogHistogramConverter.toProto(point.logHistogram));
        }

        if (StockpileColumn.HISTOGRAM.isInSet(mask)) {
            target.setHistogram(HistogramConverter.toProto(point.histogram));
        }

        if (StockpileColumn.ISUMMARY.isInSet(mask)) {
            target.setSummaryInt64(SummaryConverter.toProto(point.summaryInt64));
        }

        if (StockpileColumn.DSUMMARY.isInSet(mask)) {
            target.setSummaryDouble(SummaryConverter.toProto(point.summaryDouble));
        }
    }

    public static TPoint toProto(int mask, AggrPoint point) {
        TPoint.Builder builder = TPoint.newBuilder();
        toProto(mask, point, builder);
        return builder.build();
    }

    public static AggrPoint fromProto(int mask, TPointOrBuilder point) {
        AggrPoint target = new AggrPoint();
        fromProto(mask, point, target);
        return target;
    }
}
