package ru.yandex.stockpile.api.grpc.handler;

import java.util.concurrent.CompletableFuture;

import io.grpc.MethodDescriptor;
import io.grpc.Status;

import ru.yandex.stockpile.api.EStockpileStatusCode;
import ru.yandex.stockpile.api.StockpileServiceGrpc;
import ru.yandex.stockpile.api.TDeleteMetricByShardRequest;
import ru.yandex.stockpile.api.TDeleteMetricByShardResponse;
import ru.yandex.stockpile.server.shard.StockpileLocalShards;
import ru.yandex.stockpile.server.shard.StockpileShard;
import ru.yandex.stockpile.server.shard.StockpileWriteRequest;

/**
 * @author Vladimir Gordiychuk
 */
public class DeleteMetricByShardHandler extends ShardRequestHandler<TDeleteMetricByShardRequest, TDeleteMetricByShardResponse> {
    private static final MethodDescriptor<TDeleteMetricByShardRequest, TDeleteMetricByShardResponse> ENDPOINT =
            StockpileServiceGrpc.getDeleteMetricByShardMethod();

    public DeleteMetricByShardHandler(StockpileLocalShards shards) {
        super(shards);
    }

    @Override
    public MethodDescriptor<TDeleteMetricByShardRequest, TDeleteMetricByShardResponse> descriptor() {
        return ENDPOINT;
    }

    @Override
    public EStockpileStatusCode getStatusCode(TDeleteMetricByShardResponse response) {
        return response.getStatus();
    }

    @Override
    protected CompletableFuture<TDeleteMetricByShardResponse> unaryCall(StockpileShard shard, TDeleteMetricByShardRequest request) {
        if (request.getOwnerShardsCount() == 0) {
            return CompletableFuture.failedFuture(Status.FAILED_PRECONDITION
                    .withDescription("At least one shard should be present in request")
                    .asRuntimeException());
        }

        var req = StockpileWriteRequest.newBuilder();
        for (var ownerShard : request.getOwnerShardsList()) {
            req.addDeleteShard(ownerShard.getProjectId(), ownerShard.getShardId());
        }

        return shard.pushBatch(req.build())
                .thenApply(txn -> TDeleteMetricByShardResponse.newBuilder()
                        .setStatus(EStockpileStatusCode.OK)
                        .build());
    }

    @Override
    protected int shardId(TDeleteMetricByShardRequest request) {
        return request.getShardId();
    }

    @Override
    protected TDeleteMetricByShardResponse response(EStockpileStatusCode status, String details) {
        return TDeleteMetricByShardResponse.newBuilder()
                .setStatus(status)
                .setStatusMessage(details)
                .build();
    }
}
