package ru.yandex.stockpile.api.grpc.handler;

import java.util.concurrent.CompletableFuture;

import io.grpc.MethodDescriptor;

import ru.yandex.stockpile.api.DeleteMetricDataRequest;
import ru.yandex.stockpile.api.DeleteMetricDataResponse;
import ru.yandex.stockpile.api.EStockpileStatusCode;
import ru.yandex.stockpile.api.StockpileServiceGrpc;
import ru.yandex.stockpile.server.shard.StockpileLocalShards;
import ru.yandex.stockpile.server.shard.StockpileShard;
import ru.yandex.stockpile.server.shard.StockpileWriteRequest;

/**
 * @author Vladimir Gordiychuk
 */
public class DeleteMetricDataHandler extends ShardRequestHandler<DeleteMetricDataRequest, DeleteMetricDataResponse> {

    public DeleteMetricDataHandler(StockpileLocalShards shards) {
        super(shards);
    }

    @Override
    protected CompletableFuture<DeleteMetricDataResponse> unaryCall(StockpileShard shard, DeleteMetricDataRequest request) {
        if (!shard.canServeWrites()) {
            return CompletableFuture.completedFuture(response(EStockpileStatusCode.SHARD_NOT_READY, shard.getLoadState().name()));
        }

        var builder = StockpileWriteRequest.newBuilder();
        LogEntryAppender.appendDeleteData(builder, request);

        return shard.pushBatch(builder.build())
            .thenApply(result -> response(EStockpileStatusCode.OK));
    }

    @Override
    protected int shardId(DeleteMetricDataRequest request) {
        return request.getMetricId().getShardId();
    }

    @Override
    protected DeleteMetricDataResponse response(EStockpileStatusCode status, String details) {
        return DeleteMetricDataResponse.newBuilder()
                .setStatus(status)
                .setStatusMessage(details)
                .build();
    }

    @Override
    public MethodDescriptor<DeleteMetricDataRequest, DeleteMetricDataResponse> descriptor() {
        return StockpileServiceGrpc.getDeleteMetricDataMethod();
    }

    @Override
    public EStockpileStatusCode getStatusCode(DeleteMetricDataResponse response) {
        return response.getStatus();
    }
}
