package ru.yandex.stockpile.api.grpc.handler;

import java.util.concurrent.CompletableFuture;

import io.grpc.MethodDescriptor;

import ru.yandex.stockpile.api.DeleteMetricRequest;
import ru.yandex.stockpile.api.DeleteMetricResponse;
import ru.yandex.stockpile.api.EStockpileStatusCode;
import ru.yandex.stockpile.api.StockpileServiceGrpc;
import ru.yandex.stockpile.server.shard.StockpileLocalShards;
import ru.yandex.stockpile.server.shard.StockpileShard;
import ru.yandex.stockpile.server.shard.StockpileWriteRequest;

/**
 * @author Vladimir Gordiychuk
 */
public class DeleteMetricHandler extends ShardRequestHandler<DeleteMetricRequest, DeleteMetricResponse> {

    public DeleteMetricHandler(StockpileLocalShards shards) {
        super(shards);
    }

    @Override
    protected CompletableFuture<DeleteMetricResponse> unaryCall(StockpileShard shard, DeleteMetricRequest request) {
        if (!shard.canServeWrites()) {
            return CompletableFuture.completedFuture(response(EStockpileStatusCode.SHARD_NOT_READY, shard.getLoadState().name()));
        }

        var builder = StockpileWriteRequest.newBuilder();
        LogEntryAppender.appendDelete(builder, request);
        return shard.pushBatch(builder.build())
            .thenApply(result -> response(EStockpileStatusCode.OK));
    }

    @Override
    protected int shardId(DeleteMetricRequest request) {
        return request.getMetricId().getShardId();
    }

    @Override
    protected DeleteMetricResponse response(EStockpileStatusCode status, String details) {
        return DeleteMetricResponse.newBuilder()
                .setStatus(status)
                .setStatusMessage(details)
                .build();
    }

    @Override
    public MethodDescriptor<DeleteMetricRequest, DeleteMetricResponse> descriptor() {
        return StockpileServiceGrpc.getDeleteMetricMethod();
    }

    @Override
    public EStockpileStatusCode getStatusCode(DeleteMetricResponse response) {
        return response.getStatus();
    }
}
