package ru.yandex.stockpile.api.grpc.handler;

import java.util.concurrent.CompletableFuture;

import io.grpc.MethodDescriptor;

import ru.yandex.stockpile.api.EStockpileStatusCode;

/**
 * @author Vladimir Gordiychuk
 */
public interface Handler<ReqT, RespT> {
    CompletableFuture<RespT> unaryCall(ReqT request);
    MethodDescriptor<ReqT, RespT> descriptor();
    EStockpileStatusCode getStatusCode(RespT response);
}
