package ru.yandex.stockpile.api.grpc.handler;

import java.util.concurrent.CompletableFuture;

import io.grpc.MethodDescriptor;

import ru.yandex.stockpile.api.EStockpileStatusCode;
import ru.yandex.stockpile.api.ReadMetricsMetaRequest;
import ru.yandex.stockpile.api.ReadMetricsMetaResponse;
import ru.yandex.stockpile.api.StockpileServiceGrpc;
import ru.yandex.stockpile.server.shard.StockpileLocalShards;
import ru.yandex.stockpile.server.shard.StockpileShard;

import static java.util.concurrent.CompletableFuture.completedFuture;

/**
 * @author Vladimir Gordiychuk
 */
public class ReadMetricsMetaHandler extends ShardRequestHandler<ReadMetricsMetaRequest, ReadMetricsMetaResponse> {
    public ReadMetricsMetaHandler(StockpileLocalShards shards) {
        super(shards);
    }

    @Override
    protected CompletableFuture<ReadMetricsMetaResponse> unaryCall(StockpileShard shard, ReadMetricsMetaRequest request) {
        if (!shard.canServeReads()) {
            return completedFuture(response(EStockpileStatusCode.SHARD_NOT_READY));
        }

        // protobuf not supported primitive array, its awful
        long[] localIds = request.getLocalIdsList()
                .stream()
                .mapToLong(value -> value)
                .toArray();

        return shard.readMetricsMeta(localIds)
                .thenApply(response -> ReadMetricsMetaResponse.newBuilder()
                        .setStatus(EStockpileStatusCode.OK)
                        .addAllMeta(response)
                        .build());
    }

    @Override
    protected int shardId(ReadMetricsMetaRequest request) {
        return request.getShardId();
    }

    @Override
    protected ReadMetricsMetaResponse response(EStockpileStatusCode status, String details) {
        return ReadMetricsMetaResponse.newBuilder()
                .setStatus(status)
                .setStatusMessage(details)
                .build();
    }

    @Override
    public MethodDescriptor<ReadMetricsMetaRequest, ReadMetricsMetaResponse> descriptor() {
        return StockpileServiceGrpc.getReadMetricsMetaMethod();
    }

    @Override
    public EStockpileStatusCode getStatusCode(ReadMetricsMetaResponse response) {
        return response.getStatus();
    }
}
