package ru.yandex.stockpile.api.grpc.handler;

import java.util.concurrent.CompletableFuture;

import io.grpc.MethodDescriptor;

import ru.yandex.stockpile.api.EStockpileStatusCode;
import ru.yandex.stockpile.api.StockpileServiceGrpc;
import ru.yandex.stockpile.api.TWriteRequest;
import ru.yandex.stockpile.api.TWriteResponse;
import ru.yandex.stockpile.server.shard.StockpileLocalShards;
import ru.yandex.stockpile.server.shard.StockpileShard;
import ru.yandex.stockpile.server.shard.StockpileWriteRequest;

/**
 * @author Vladimir Gordiychuk
 */
public class WriteOneHandler extends ShardRequestHandler<TWriteRequest, TWriteResponse> {

    public WriteOneHandler(StockpileLocalShards shards) {
        super(shards);
    }

    @Override
    protected CompletableFuture<TWriteResponse> unaryCall(StockpileShard shard, TWriteRequest request) {
        Validator.ensureValid(request);
        var builder = StockpileWriteRequest.newBuilder();
        LogEntryAppender.appendWrite(builder, request);
        return shard.pushBatch(builder.build())
            .thenApply(result -> response(EStockpileStatusCode.OK, ""));
    }

    @Override
    protected int shardId(TWriteRequest request) {
        return request.getMetricId().getShardId();
    }

    @Override
    protected TWriteResponse response(EStockpileStatusCode status, String details) {
        return TWriteResponse.newBuilder()
                .setStatus(status)
                .setStatusMessage(details)
                .build();
    }

    @Override
    public MethodDescriptor<TWriteRequest, TWriteResponse> descriptor() {
        return StockpileServiceGrpc.getWriteOneMethod();
    }

    @Override
    public EStockpileStatusCode getStatusCode(TWriteResponse response) {
        return response.getStatus();
    }
}
