package ru.yandex.stockpile.api.grpc.handler.parse;

import java.io.IOException;

import com.google.protobuf.CodedInputStream;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

import ru.yandex.solomon.codec.CorruptedBinaryDataRuntimeException;
import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.stockpile.client.shard.StockpileShardId;
import ru.yandex.stockpile.client.writeRequest.StockpileShardWriteRequest;

/**
 * @author Vladimir Gordiychuk
 */
public class TWriteDataBinaryRequestParser {

    public static WriteDataBinaryRequest parse(CodedInputStream input) {
        try {
            long startNanos = System.nanoTime();
            Long2ObjectOpenHashMap<MetricArchiveMutable> archiveByLocalId = new Long2ObjectOpenHashMap<>();
            int shardId = StockpileShardId.INVALID_SHARD_ID;
            boolean done = false;
            while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0:
                        done = true;
                        break;
                    default: {
                        if (!input.skipField(tag)) {
                            done = true;
                        }
                        break;
                    }
                    case 8: {
                        shardId = input.readUInt32();
                        break;
                    }
                    case 106: {
                        final int size = input.readRawVarint32();
                        int oldLimit = input.pushLimit(size);
                        StockpileShardWriteRequest.deserializeTo(input, archiveByLocalId);
                        if (!input.isAtEnd()) {
                            throw new CorruptedBinaryDataRuntimeException("remaining: " + input.getBytesUntilLimit());
                        }
                        input.popLimit(oldLimit);
                        break;
                    }
                }
            }
            return new WriteDataBinaryRequest(shardId, archiveByLocalId, System.nanoTime() - startNanos);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
