package ru.yandex.stockpile.api.grpc.mem;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

import ru.yandex.stockpile.server.shard.StockpileWriteRequest;

/**
 * @author Vladimir Gordiychuk
 */
@NotThreadSafe
@ParametersAreNonnullByDefault
public class ShardBatchRequest implements AutoCloseable {
    private final int shardId;
    @Nullable
    private StockpileWriteRequest write;
    private final long recordsCount;
    public final long parseTimeNanos;

    public ShardBatchRequest(int shardId, StockpileWriteRequest content, long recordsCount, long parseTimeNanos) {
        this.shardId = shardId;
        this.write = content;
        this.recordsCount = recordsCount;
        this.parseTimeNanos = parseTimeNanos;
    }

    public int getShardId() {
        return shardId;
    }

    @Nullable
    public StockpileWriteRequest getContent() {
        return write;
    }

    public boolean isEmpty() {
        return recordsCount == 0;
    }

    public long countRecords() {
        return recordsCount;
    }

    @Override
    public String toString() {
        return "ShardBatchRequest{" +
            "shardId=" + shardId +
            ", recordsCount=" + recordsCount +
            '}';
    }

    @Override
    public void close() {
        write = null;
    }
}
