package ru.yandex.stockpile.api.read;

import java.util.Collections;
import java.util.List;

import ru.yandex.solomon.math.protobuf.Operation;
import ru.yandex.solomon.math.protobuf.OperationDownsampling;
import ru.yandex.solomon.model.point.RecyclableAggrPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.stockpile.api.TPoint;
import ru.yandex.stockpile.api.TReadManyRequest;
import ru.yandex.stockpile.api.TReadRequest;
import ru.yandex.stockpile.api.TTimeseriesUncompressed;
import ru.yandex.stockpile.api.grpc.TPointConverters;

/**
 * @author Vladimir Gordiychuk
 */
public class Converters {
    public static TReadManyRequest makeRequest(TReadRequest request) {
        return TReadManyRequest.newBuilder()
                .setDeadline(request.getDeadline())
                .setShardId(request.getMetricId().getShardId())
                .addLocalIds(request.getMetricId().getLocalId())
                .setFromMillis(request.getFromMillis())
                .setToMillis(request.getToMillis())
                .addAllOperations(makeOperations(request))
                .setProducer(request.getProducer())
                .build();
    }

    public static List<Operation> makeOperations(TReadRequest request) {
        // downsampling
        if (request.getGridMillis() > 0) {
            return Collections.singletonList(convertDownsampling(request));
        }

        return Collections.emptyList();
    }

    private static Operation convertDownsampling(TReadRequest request) {
        return Operation.newBuilder()
                .setDownsampling(OperationDownsampling.newBuilder()
                        .setGridMillis(request.getGridMillis())
                        .setAggregation(request.getAggregation())
                        .build())
                .build();
    }

    public static TTimeseriesUncompressed toProto(AggrGraphDataIterable iterable) {
        return toProto(iterable.iterator());
    }

    public static TTimeseriesUncompressed toProto(AggrGraphDataListIterator it) {
        TTimeseriesUncompressed.Builder result = TTimeseriesUncompressed.newBuilder();
        var temp = RecyclableAggrPoint.newInstance();
        try {
            TPoint.Builder point = TPoint.newBuilder();
            while (it.next(temp)) {
                point.clear();
                TPointConverters.toProto(it.columnSetMask(), temp, point);
                result.addPoints(point.build());
            }
        } finally {
            temp.recycle();
        }

        return result.build();
    }
}
