package ru.yandex.stockpile.cluster;

import java.time.Clock;
import java.util.concurrent.ScheduledExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.locks.DistributedLock;
import ru.yandex.solomon.locks.LockService;
import ru.yandex.solomon.locks.LockServiceImpl;
import ru.yandex.solomon.locks.dao.LocksDao;
import ru.yandex.solomon.util.host.HostUtils;
import ru.yandex.stockpile.cluster.balancer.StockpileBalancerLock;
import ru.yandex.stockpile.server.StockpileKikimrPersistenceContext;
import ru.yandex.stockpile.server.shard.StockpileScheduledExecutor;

/**
 * @author Vladimir Gordiychuk
 */
@Import({
    StockpileKikimrPersistenceContext.class
})
@Configuration
public class StockpileLockServiceContext {
    @Bean
    public LockService lockService(
        LocksDao locksDao,
        Clock clock,
        @StockpileScheduledExecutor ScheduledExecutorService timer,
        MetricRegistry registry)
    {
        return new LockServiceImpl(HostUtils.getFqdn(), locksDao, clock, timer, registry);
    }

    @Bean
    @StockpileBalancerLock
    public DistributedLock balancerLock(LockService lockService) {
        return lockService.distributedLock("Balancer");
    }
}
