package ru.yandex.stockpile.cluster.balancer;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import ru.yandex.solomon.balancer.ShardsHolder;
import ru.yandex.stockpile.client.shard.StockpileShardId;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileShardsHolder implements ShardsHolder {
    private final KvTabletClient kvTabletClient;
    private volatile Set<String> shards;

    public StockpileShardsHolder(KvTabletClient kvTabletClient) {
        this.kvTabletClient = kvTabletClient;
        this.shards = Set.of();
    }

    @Override
    public CompletableFuture<Void> reload() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Set<String> getShards() {
        int count = kvTabletClient.getShardCount();
        if (shards.size() == count) {
            return shards;
        }

        var shards = IntStream.rangeClosed(StockpileShardId.FIRST_SHARD_ID, count)
                .mapToObj(StockpileShardId::toString)
                .collect(Collectors.toUnmodifiableSet());
        this.shards = shards;
        return shards;
    }

    @Override
    public CompletableFuture<Void> add(String shardId) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> delete(String shardId) {
        return CompletableFuture.completedFuture(null);
    }
}
